<?php
require("../sy-config.php");
session_start();
header("Expires: Mon, 26 Jul 1990 05:00:00 GMT");
header("Last-Modified: " . gmdate("D, d M Y H:i:s") . " GMT");
header("Cache-Control: no-store, no-cache, must-revalidate");
header("Cache-Control: post-check=0, pre-check=0", false);
header("Pragma: no-cache");
header('Content-Type: text/html; charset=utf-8');
ob_start(); 
require $setup['path']."/".$setup['inc_folder']."/functions.php";
require $setup['path']."/".$setup['inc_folder']."/store/store_functions.php";
require $setup['path']."/".$setup['inc_folder']."/photos_functions.php";
$dbcon = dbConnect($setup);
$site_setup = doSQL("ms_settings", "*", "");
$store = doSQL("ms_store_settings", "*", "");

if($site_setup['error_reporting'] == "1") { 
	error_reporting(E_ALL ^ E_NOTICE ^ E_WARNING ^ E_DEPRECATED);
} else if($site_setup['error_reporting'] == "2") { 
	error_reporting(E_ALL ^ E_NOTICE ^ E_WARNING);
} else if($site_setup['error_reporting'] == "3") { 
	error_reporting(E_ALL ^ E_NOTICE);
} else if($site_setup['error_reporting'] == "4") { 
	error_reporting(E_ALL);
} else { 
	error_reporting(0);
}
date_default_timezone_set(''.$site_setup['time_zone'].'');
$lang = doSQL("ms_language", "*", "");
foreach($lang AS $id => $val) {
	if(!is_numeric($id)) {
		define($id,$val);
	}
}
$storelang = doSQL("ms_store_language", "*", " ");
foreach($storelang AS $id => $val) {
	if(!is_numeric($id)) {
		define($id,$val);
	}
}

if(empty($_REQUEST['Caller'])) { header("HTTP/1.0 404 Not Found"); die(); } 

$t = doSQL("ms_sms", "*", "");

require $setup['path']. '/sy-inc/Twilio/autoload.php';

use Twilio\Security\RequestValidator;

$account_sid = $t['sid'];
$token = $t['token'];
$twilio_number = $t['phone']; // Twilio number you own

$signature = $_SERVER["HTTP_X_TWILIO_SIGNATURE"];
if(empty($signature)) { die("no signature"); } 
// Initialize the validator
$validator = new RequestValidator($token);

$url = $_SERVER['REQUEST_SCHEME']."://".$_SERVER['HTTP_HOST'].$_SERVER['PHP_SELF'];

$postVars = $_POST;
if(($setup['twilio_callback_validate_signature'] == true) && (!empty($signature)) == true) { 
	$valid_request = true;
} else { 

	if ($validator->validate($signature, $url, $postVars)) {
		$valid_request = true;
		// Appears to be from Twilio, move along 
	} else {
		die("Not Twilio");
	}
}

use Twilio\TwiML\VoiceResponse;

header("content-type: text/xml");

if($t['call_received'] == "message") { 
	$html .= '<?xml version="1.0" encoding="UTF-8"?> ';
	$html .= '<Response>';
	$html .= ' <Say voice="'.$t['voice'].'" language="'.$t['language'].'">'.$t['voice_message'].'</Say>';
	$html .= '</Response>';
	print $html;

	foreach($_REQUEST AS $f => $v) { 
		$d .= $f." -> ".$v."<br>";
	}

	insertSQL("ms_sms_log", "date_time='".currentdatetime()."', to_number='".addslashes(stripslashes(trim($_REQUEST['Called'])))."', message='".addslashes(stripslashes(trim($t['voice_message'])))."', from_number='".addslashes(stripslashes(trim($_REQUEST['Caller'])))."', sent_received='2', sms_phone='phone', action_taken='message', all_data='".addslashes(stripslashes(trim($d)))."'  ");
	exit();
}


if($t['call_received'] == "forward") { 
	$html .= '<?xml version="1.0" encoding="UTF-8"?> ';
	$html .= '<Response>';
	$html .= ' <Dial>'.$t['call_forward'].'</Dial>';
	$html .= ' <Say voice="woman" language="en">Good bye</Say>';
	$html .= '</Response>';
	print $html;

	foreach($_REQUEST AS $f => $v) { 
		$d .= $f." -> ".$v."<br>";
	}

	insertSQL("ms_sms_log", "date_time='".currentdatetime()."', to_number='".addslashes(stripslashes(trim($_REQUEST['Called'])))."', message='".addslashes(stripslashes(trim($_REQUEST['Body'])))."', from_number='".addslashes(stripslashes(trim($_REQUEST['Caller'])))."', sent_received='2', sms_phone='phone', action_taken='forward', action_to='".addslashes(stripslashes(trim($t['call_forward'])))."'  ");
	exit();
}




?>