<?php
require "../../../sy-config.php";
session_start();
ini_set('display_errors', 1); 
header("Expires: Mon, 26 Jul 1990 05:00:00 GMT");
header("Last-Modified: " . gmdate("D, d M Y H:i:s") . " GMT");
header("Cache-Control: no-store, no-cache, must-revalidate");
header("Cache-Control: post-check=0, pre-check=0", false);
header("Pragma: no-cache");
header('Content-Type: text/html; charset=utf-8');
ob_start(); 
require $setup['path']."/".$setup['inc_folder']."/functions.php";
require $setup['path']."/".$setup['inc_folder']."/store/store_functions.php";
require $setup['path']."/".$setup['inc_folder']."/photos_functions.php";
$dbcon = dbConnect($setup);
$site_setup = doSQL("ms_settings", "*", "");
$store = doSQL("ms_store_settings", "*", "");
date_default_timezone_set(''.$site_setup['time_zone'].'');
require $setup['path']."/".$setup['inc_folder']."/php-8-adjustments.php"; 

if($site_setup['error_reporting'] == "1") { 
	error_reporting(E_ALL ^ E_NOTICE ^ E_WARNING ^ E_DEPRECATED);
} else if($site_setup['error_reporting'] == "2") { 
	error_reporting(E_ALL ^ E_NOTICE ^ E_WARNING);
} else if($site_setup['error_reporting'] == "3") { 
	error_reporting(E_ALL ^ E_NOTICE);
} else if($site_setup['error_reporting'] == "4") { 
	error_reporting(E_ALL);
} else { 
	error_reporting(0);
}
$lang = doSQL("ms_language", "*", "");
foreach($lang AS $id => $val) {
	if(!is_numeric($id)) {
		define($id,$val);
	}
}
$storelang = doSQL("ms_store_language", "*", " ");
foreach($storelang AS $id => $val) {
	if(!is_numeric($id)) {
		define($id,$val);
	}
}
$glang = doSQL("ms_gift_certificate_language", "*", " ");
foreach($glang AS $id => $val) {
	if(!is_numeric($id)) {
		define($id,$val);
	}
}
if($site_setup['include_vat'] == "1") { 
	$def = doSQL("ms_countries", "*", "WHERE def='1' ");
	$site_setup['include_vat_rate'] = $def['vat'];
}

foreach($_REQUEST AS $id => $value) {
	if(!empty($value)) { 
		if(!is_array($value)) { 
			$_REQUEST[$id] = sql_safe("".$_REQUEST[$id]."");
			$_REQUEST[$id] = addslashes(stripslashes(stripslashes(strip_tags(trim(sql_safe($value))))));
		}
	}
}



require_once($setup['path']."/sy-inc/store/payment/stripe2/init.php");

$pay = doSQL("ms_payment_options", "*", "WHERE pay_option='stripe2' ");
$secretkey = $pay['pay_key'];
$publishkey = $pay['pay_num'];
$webhooksecret = $pay['pay_private_key'];


// Set your secret key: remember to change this to your live secret key in production
// See your keys here: https://dashboard.stripe.com/account/apikeys
\Stripe\Stripe::setApiKey($secretkey);

// You can find your endpoint's secret in your webhook settings
$endpoint_secret = $webhooksecret;

$payload = @file_get_contents('php://input');
$sig_header = $_SERVER['HTTP_STRIPE_SIGNATURE'];
$event = null;

try {
  $event = \Stripe\Webhook::constructEvent(
    $payload, $sig_header, $endpoint_secret
  );
} catch(\UnexpectedValueException $e) {
  // Invalid payload
  http_response_code(400); // PHP 5.4 or greater
  exit();
} catch(\Stripe\Error\SignatureVerification $e) {
  // Invalid signature
  http_response_code(400); // PHP 5.4 or greater
  exit();
}




// Handle the checkout.session.completed event
if ($event->type == 'checkout.session.completed') {

	$session = $event->data->object;

  // Fulfill the purchase...
  // handle_checkout_session($session);

	$pending_order = $session->client_reference_id;
	$payment_email = $session->customer_email;
	$payment_intent = $session->payment_intent;
	$order_pay_transaction = $payment_intent;

	$pi = \Stripe\PaymentIntent::retrieve($payment_intent);
	$pi_amount = $pi->amount;
	$application_fee_amount = $pi->application_fee_amount;
	$payment_method = $pi->payment_method;

	/* payment method 
	https://stripe.com/docs/api/payment_methods/retrieve
	*/
	$pm = \Stripe\PaymentMethod::retrieve($pi->payment_method);
	$cardbrand = $pm->card->brand;
	$last4 = $pm->card->last4;


	/* Emailing test data */
	/* 
	$info .= "pending order: ".$pending_order."\r\n";
	$info .= "email: ".$payment_email."\r\n";
	$info .= "payment intent amount: ".$pi_amount."\r\n";
	$info .= "payment method: ".$payment_method."\r\n";
	$info .= "card brand: ".$cardbrand."\r\n";
	$info .= "payment method 2: ".$pm->card->brand."\r\n";
	$info .= "application_fee_amount: ".$application_fee_amount."\r\n";
	$info .= "URL: ".$_SERVER['HTTP_HOST'].$_SERVER['REQUEST_URI']."\r\n";
	$subject = "TESTING Stripe";
	$additional_headers = "From: \"Tim\" <info@picturespro.com>\nReply-To: info@picturespro.com";
	mail("info@picturespro.com",$subject,$info,$additional_headers);
	*/


	$pending_order = doSQL("ms_pending_orders", "*", "WHERE  order_id='".$pending_order."'  ORDER BY order_id DESC");
	if(!empty($pending_order['order_id'])) {
		$order_first_name=$pending_order['order_first_name'];
		$order_last_name=$pending_order['order_last_name'];
		$order_email=$pending_order['order_email'];
		$order_address=$pending_order['order_address'];
		$order_city=$pending_order['order_city'];
		$order_state=$pending_order['order_state'];
		$order_country=$pending_order['order_country'];
		$order_zip=$pending_order['order_zip'];
		if(!empty($pending_order['order_join_ml'])) {
			$order_join_ml=$pending_order['order_email'];
		}
		$order_phone=$pending_order['order_phone'];
		$order_company=$pending_order['order_company'];

		$order_ship_business=$pending_order['order_ship_business'];
		$order_ship_first_name=$pending_order['order_ship_first_name'];
		$order_ship_last_name=$pending_order['order_ship_last_name'];
		$order_ship_email=$pending_order['order_ship_email'];
		$order_ship_address=$pending_order['order_ship_address'];
		$order_ship_city=$pending_order['order_ship_city'];
		$order_ship_state=$pending_order['order_ship_state'];
		$order_ship_country=$pending_order['order_ship_country'];
		$order_ship_zip=$pending_order['order_ship_zip'];

		$order_ship_amount = $pending_order['order_shipping'];
		$order_tax = $pending_order['order_tax'];
		$order_discount = $pending_order['order_discount'];
		$order_sub_total = $pending_order['order_sub_total'];
		$order_shipping_option = $pending_order['order_shipping_option'];
		$order_coupon_id= $pending_order['order_coupon_id'];
		$order_coupon_name = $pending_order['order_coupon_name'];
		$order_vat = $pending_order['order_vat'];
		$order_vat_percentage = $pending_order['order_vat_percentage'];
		$order_eb_discount = $pending_order['order_eb_discount'];

		$order_tax_percentage = $pending_order['order_tax_percentage'];
		$order_taxable_amount= $pending_order['order_taxable_amount'];
		$order_key= $pending_order['order_key'];
		$customer_id= $pending_order['order_customer'];
		$credit_amount= $pending_order['order_credit'];
		$gift_certificate_amount= $pending_order['order_gift_certificate'];
		$gift_certificate_id= $pending_order['order_gift_certificate_id'];
		$order_notes= $pending_order['order_notes'];
		$order_extra_field_1 = $pending_order['order_extra_field_1'];
		$order_extra_val_1 = $pending_order['order_extra_val_1'];
		$order_extra_field_2 = $pending_order['order_extra_field_2'];
		$order_extra_val_2 = $pending_order['order_extra_val_2'];
		$order_extra_field_3 = $pending_order['order_extra_field_3'];
		$order_extra_val_3 = $pending_order['order_extra_val_3'];
		$order_extra_field_4 = $pending_order['order_extra_field_4'];
		$order_extra_val_4 = $pending_order['order_extra_val_4'];
		$order_extra_field_5 = $pending_order['order_extra_field_5'];
		$order_extra_val_5 = $pending_order['order_extra_val_5'];
		$order_gallery_email_no_consent = $pending_order['order_gallery_email_no_consent'];
		$order_phone_consent = $pending_order['order_phone_consent'];
		$payment_amount = $pending_order['order_total'];

		deleteSQL("ms_pending_orders", "WHERE order_id='".$pending_order['order_id']."' ","1");

		$order_payment_status = "Completed";
		$sub_total = $order_sub_total;
		$shipping_option = $order_shipping_option;
		$coupon_id = $order_coupon_id;
		$coupon_name = $order_coupon_name;
		$order_key=$order_key;
		$order_total_pay = $payment_amount;
		$order_fees = $payment_fees;
		$currency = $store['currency'];
		$transaction_id = $order_pay_transaction;
		$order_ship_amount = $order_ship_amount;
		$order_tax = $order_tax;
		$tax_percentage = $order_tax_percentage;
		$taxable_amount= $order_taxable_amount;
		$vat = $order_vat;
		$vat_percentage = $order_vat_percentage;
		$order_discount = $order_discount;
		$order_message  = $_POST['customer_message'];
		$order_pay_type = $cardbrand;
		$pay_option = "stripe2";
		$first_name = $order_first_name;
		$last_name = $order_last_name;
		$email_address = $order_email;
		$company_name = $order_company;
		$country = $order_country;
		$city = $order_city;
		$state = $order_state;
		$zip = $order_zip;
		$address = $order_address;
		$phone = $order_phone;
		$order_session = $pending_order['order_session'];
		$ship_business = $order_ship_business;
		$ship_first_name = $order_ship_first_name;
		$ship_last_name =  $order_ship_last_name;
		$ship_address  = $order_ship_address;
		$ship_city = $order_ship_city;
		$ship_state = $order_ship_state;
		$ship_zip = $order_ship_zip;
		$ship_country = $order_ship_country;
		$order_address_status = $_POST['address_status'];
		$order_payer_status = $_POST['payer_status'];
		
		$ip_address = $pending_order['order_ip'];
		$no_redirect = true;
		if($pending_order['order_order_id'] > 0) { 
			$_POST['order_id'] = $pending_order['order_order_id'];
			$_REQUEST['order_id'] = $pending_order['order_order_id'];

			$order_id = $pending_order['order_order_id'];
			include $setup['path']."/sy-inc/store/payment/payment-complete-pay-invoice.php";
		} else { 
			include $setup['path']."/sy-inc/store/payment/payment-complete.php";
			$order_id = createOrder();
		}


		\Stripe\PaymentIntent::update(
		  $payment_intent,
		  [
			'description' => $site_setup['website_title']." Order #".$order_id,
		  ]
		);
	} 

}

http_response_code(200); // PHP 5.4 or greater
?>