<?php
require("../sy-config.php");
session_start();
header("Expires: Mon, 26 Jul 1990 05:00:00 GMT");
header("Last-Modified: " . gmdate("D, d M Y H:i:s") . " GMT");
header("Cache-Control: no-store, no-cache, must-revalidate");
header("Cache-Control: post-check=0, pre-check=0", false);
header("Pragma: no-cache");
header('Content-Type: text/html; charset=utf-8');
ob_start(); 
require $setup['path']."/".$setup['inc_folder']."/functions.php";
require $setup['path']."/".$setup['inc_folder']."/store/store_functions.php";
require $setup['path']."/".$setup['inc_folder']."/photos_functions.php";
$dbcon = dbConnect($setup);
$site_setup = doSQL("ms_settings", "*", "");
$store = doSQL("ms_store_settings", "*", "");

if($site_setup['error_reporting'] == "1") { 
	error_reporting(E_ALL ^ E_NOTICE ^ E_WARNING ^ E_DEPRECATED);
} else if($site_setup['error_reporting'] == "2") { 
	error_reporting(E_ALL ^ E_NOTICE ^ E_WARNING);
} else if($site_setup['error_reporting'] == "3") { 
	error_reporting(E_ALL ^ E_NOTICE);
} else if($site_setup['error_reporting'] == "4") { 
	error_reporting(E_ALL);
} else { 
	error_reporting(0);
}
date_default_timezone_set(''.$site_setup['time_zone'].'');
$lang = doSQL("ms_language", "*", "");
foreach($lang AS $id => $val) {
	if(!is_numeric($id)) {
		define($id,$val);
	}
}
$storelang = doSQL("ms_store_language", "*", " ");
foreach($storelang AS $id => $val) {
	if(!is_numeric($id)) {
		define($id,$val);
	}
}

$t = doSQL("ms_sms", "*", "");

if(empty($_REQUEST['From'])) { header("HTTP/1.0 404 Not Found"); die(); } 

require $setup['path']. '/sy-inc/Twilio/autoload.php';

use Twilio\Security\RequestValidator;

$account_sid = $t['sid'];
$token = $t['token'];
$twilio_number = $t['phone']; // Twilio number you own

$signature = $_SERVER["HTTP_X_TWILIO_SIGNATURE"];
if(empty($signature)) { die("no signature"); } 
// Initialize the validator
$validator = new RequestValidator($token);

$url = $_SERVER['REQUEST_SCHEME']."://".$_SERVER['HTTP_HOST'].$_SERVER['PHP_SELF'];

$postVars = $_POST;
if(($setup['twilio_callback_validate_signature'] == true) && (!empty($signature)) == true) { 
	$valid_request = true;
} else { 

	if ($validator->validate($signature, $url, $postVars)) {
		$valid_request = true;
		// Appears to be from Twilio, move along 
	} else {
		die("Not Twilio");
	}
}

use Twilio\TwiML\MessagingResponse;
header("content-type: text/xml");

foreach($_REQUEST AS $f => $v) { 
	$d .= $f." -> ".$v."<br>";
}

if($_REQUEST['NumMedia'] > 0) { 
	$media_email = "<p><ul>";
	for ($i=0; $i < $_REQUEST['NumMedia']; $i++) {
		if($i > 0) { 
			$media .= "|";
		}
		$media .= $_REQUEST["MediaUrl".$i];
		$media_email .= "<li>".$_REQUEST["MediaUrl".$i]."</li>";
	}
	$media_email .= "</ul></p>";
}

if($t['response_received'] == "message") { 
	/* ###### Replying with a message */
	$html .= '<?xml version="1.0" encoding="UTF-8"?> ';
	$html .= '<Response>';
	$html .= '<Message>';
	$html .= $t['message_reply'];
	$html .= '</Message>';
	$html .= '</Response>';
	print $html;

	insertSQL("ms_sms_log", "date_time='".currentdatetime()."', to_number='".addslashes(stripslashes(trim($_REQUEST['To'])))."', message='".addslashes(stripslashes(trim($_REQUEST['Body'])))."', from_number='".addslashes(stripslashes(trim($_REQUEST['From'])))."', sent_received='2', sms_phone='sms', action_taken='message', action_to='".addslashes(stripslashes(trim($t['message_reply'])))."', all_data='".addslashes(stripslashes(trim($d)))."', media='".addslashes(stripslashes(trim($media)))."'  ");

	exit();
}


if($t['response_received'] == "forward") { 

	/* ###### Sending to phone ########## */

	$id = $_POST['MessageSid'];
	$from = $_POST['from'];
	$to = $_POST['to'];
	$message = $_POST['body'];
	$to_number = $t['message_forward'];


	if($_REQUEST['NumMedia'] > 0) { 
		$add_message = " [Media attached unable to forward. Review logs for attached media.]";
	} else { 
		$add_message = "";
	}

	if(!empty($_REQUEST['From'])) { 
		$html = '<?xml version="1.0" encoding="UTF-8"?> ';
		print $html;
		?>
		<Response>
			<Message to="<?=$to_number?>"> <?=htmlspecialchars(substr($_REQUEST['From'] . ": " . $_REQUEST['Body'].$add_message, 0, 1600))?> </Message>
		</Response>
	<?php } 

	insertSQL("ms_sms_log", "date_time='".currentdatetime()."', to_number='".addslashes(stripslashes(trim($_REQUEST['To'])))."', message='".addslashes(stripslashes(trim($_REQUEST['Body'])))."', from_number='".addslashes(stripslashes(trim($_REQUEST['From'])))."', sent_received='2', sms_phone='sms', action_taken='forward', action_to='".addslashes(stripslashes(trim($t['message_forward'])))."', all_data='".addslashes(stripslashes(trim($d)))."', media='".addslashes(stripslashes(trim($media)))."'   ");

	exit();
}


if($t['response_received'] == "email") { 

	/* #### SEND TO AN EMAIL ######### */
	$subject = "Message from {$_REQUEST['From']} to {$_REQUEST['To']} (Twilio number)"; 
	$message = "You have received a text message from <a href=\"tel:{$_REQUEST['From']}\">{$_REQUEST['From']}</a> to your Twilio number.<br><br><i> {$_REQUEST['Body']} ".$media_email."</i><br><br>Sent from your site ".$setup['url'].$setup['temp_url_folder']."<br><br>"; 
	$from_email = $site_setup['contact_email'];
	$to_email = $t['message_email'];
	$from_name = $site_setup['website_title'];
	$to_name = $site_setup['website_title'];

	sendWebdEmail($to_email, $to_name, $from_email, $from_name, $subject, $message,"1");

	insertSQL("ms_sms_log", "date_time='".currentdatetime()."', to_number='".addslashes(stripslashes(trim($_REQUEST['To'])))."', message='".addslashes(stripslashes(trim($_REQUEST['Body'])))."', from_number='".addslashes(stripslashes(trim($_REQUEST['From'])))."', sent_received='2', sms_phone='sms', action_taken='email', action_to='".addslashes(stripslashes(trim($t['message_email'])))."', all_data='".addslashes(stripslashes(trim($d)))."' , media='".addslashes(stripslashes(trim($media)))."'  ");

	exit();
}

if($t['response_received'] == "nothing") { 
	/* ###### Replying with a message */
	$html .= '<?xml version="1.0" encoding="UTF-8"?> ';
	$html .= '<Response>';
	$html .= '</Response>';
	print $html;

	insertSQL("ms_sms_log", "date_time='".currentdatetime()."', to_number='".addslashes(stripslashes(trim($_REQUEST['To'])))."', message='".addslashes(stripslashes(trim($_REQUEST['Body'])))."', from_number='".addslashes(stripslashes(trim($_REQUEST['From'])))."', sent_received='2', sms_phone='sms', action_taken='nothing', all_data='".addslashes(stripslashes(trim($d)))."', media='".addslashes(stripslashes(trim($media)))."'   ");
	exit();
}

?>