<?php

namespace paypalcheckout;
require __DIR__ . '/autoload.php';
//1. Import the PayPal SDK client that was created in `Set up Server-Side SDK`.
use PayPalClient;
use PayPalCheckoutSdk\Orders\OrdersCreateRequest;
if(($payinfo['test_mode'] == "1") || (	$_SESSION['paypal_checkout_test_mode'] == true) == true) { 
	require_once __DIR__ ."/PayPalCheckoutSdk/PayPalClientSandbox.php";
} else { 
	require_once __DIR__ ."/PayPalCheckoutSdk/PayPalClient.php";
}
class CreateOrder
{

// 2. Set up your server to receive a call from the client
  /**
   *This is the sample function to create an order. It uses the
   *JSON body returned by buildRequestBody() to create an order.
   */
  public static function createOrder($debug=false)
  {

    $request = new OrdersCreateRequest();
    $request->prefer('return=representation');
    $request->body = self::buildRequestBody();
   // 3. Call PayPal to set up a transaction
    $client = PayPalClient::client();
    $response = $client->execute($request);
    if ($debug)
    {
    //  print "Status Code: {$response->statusCode}\n";
   //   print "Status: {$response->result->status}\n";
   //   print "Order ID: {$response->result->id}\n";
   //   print "Intent: {$response->result->intent}\n";
   //   print "Links:\n";
      foreach($response->result->links as $link)
      {
     //   print "\t{$link->rel}: {$link->href}\tCall Type: {$link->method}\n";
      }

      // To print the whole response body, uncomment the following line
      // echo json_encode($response->result, JSON_PRETTY_PRINT);

    }

    // 4. Return a successful response to the client.
    echo json_encode($response->result, JSON_PRETTY_PRINT);
  }

  /**
     * Setting up the JSON request body for creating the order with minimum request body. The intent in the
     * request body should be "AUTHORIZE" for authorize intent flow.
     *
     */
    private static function buildRequestBody()
    {
        return array(
            'intent' => 'CAPTURE',
            'application_context' =>
                array(
					'shipping_preference' => 'NO_SHIPPING', 
                    'return_url' => $_GET['storeURL']."/index.php?view=checkout",
                    'cancel_url' => $_GET['storeURL']."/index.php?view=checkout"
                ),

            'payer' =>
				array(
					'name' =>
						array(
							'given_name' => "BOB",
							'surname' => "Bobbyson"
						),

					'address' =>
						array(
							'postal_code' => "36350",
							'address_line_1' => "test",
							'country_code' => 'US'
						),
					'email_address' => 'info@picturespro.com',
					'phone' =>
						array(
							'phone_number' => array(
								'national_number' => "1"
							)
						),


                ),

            'purchase_units' =>
                array(
                    0 =>
                        array(
                            'amount' =>
                                array(
                                    'currency_code' => $_GET['currency'],
                                    'value' => $_GET['amount']
                                )
                        )
                )
        );
    }
}


/**
 *This is the driver function that invokes the createOrder function to create
 *a sample order.
 */
if (!count(debug_backtrace()))
{
  CreateOrder::createOrder(true);
}
?>