<?php


use PayPalCheckoutSdk\Core\PayPalHttpClient;
use PayPalCheckoutSdk\Core\ProductionEnvironment;

ini_set('error_reporting', E_ALL); // or error_reporting(E_ALL);
ini_set('display_errors', '1');
ini_set('display_startup_errors', '1');

class PayPalClient
{
    /**
     * Returns PayPal HTTP client instance with environment which has access
     * credentials context. This can be used invoke PayPal API's provided the
     * credentials have the access to do so.
     */
    public static function client()
    {
        return new PayPalHttpClient(self::environment());
    }
    
    /**
     * Setting up and Returns PayPal SDK environment with PayPal Access credentials.
     * For demo purpose, we are using SandboxEnvironment. In production this will be
     * ProductionEnvironment.
     */
    public static function environment()
    {
		$payinfo = doSQL("ms_payment_options", "*", "WHERE pay_option='paypalcheckout' "); 
        $clientId = getenv("CLIENT_ID") ?: $payinfo['pay_num'];
        $clientSecret = getenv("CLIENT_SECRET") ?: $payinfo['pay_key'];
        return new ProductionEnvironment($clientId, $clientSecret);
    }
}
