function priceFormat(price) { 
	price = parseFloat(price).toFixed(2);
	fprice  = pformat.replace("[CURRENCY_SIGN]", cursign);
	fprice  = fprice.replace("[PRICE]", price);
	return fprice;
}



function monthlyGraph() {
	$.ajax({
		url:'chart-actions.php?view=monthytotals&year='+$("#reportchartdata").attr("data-year"),
		type:"POST",
		contentType:"application/json; charset=utf-8",
		dataType:"json",
		success: function(data){                    
			console.log(data);

			var month = [];
			var salestotal = [];
			var salestotalshow = [];
			var expensetotal = [];
			var expensetotalshow = [];

			for (var i in data) {
				console.log(data[i]);
				month.push(data[i].month);
				salestotal.push(data[i].salestotal);
				salestotalshow.push(data[i].salestotalshow);
				expensetotal.push(data[i].expensetotal);
			}

			var chartdata = {
				labels: month,
				datasets: [
				{
					type: 'line',
					fill: false,
					label: 'Expenses',
					backgroundColor: 'rgba(255,73,73,.7)',
					borderColor: 'rgba(255,73,73,.7)',
					hoverBackgroundColor: 'rgba(255,99,99,.7)',
					hoverBorderColor: 'rgba(255,99,99,.7)',
					data: expensetotal
				},
				{
					label: 'Sales',
					backgroundColor: 'rgba(73,226,255,.7)',
					borderColor: '#38c4df',
					hoverBackgroundColor: 'rgba(0,0,0,.7)',
					hoverBorderColor: '#666666',
					data: salestotal
				}
			],
		};

		var graphTarget = $("#graphCanvas");
		var barGraph = new Chart(graphTarget, {
			type: 'bar',
			data: chartdata,
			options: {
				 responsive: true,
				tooltips: {
					 mode: 'label',
						intersect: true,
						/*
						callbacks: {
							label: function(tooltipItem, data) {
								var value = data.datasets[0].data[tooltipItem.index];
								 return priceFormat(value).replace(/\B(?=(\d{3})+(?!\d))/g, ",");
							}
						  } // end callbacks:
						  */
						},
	

					maintainAspectRatio: false,
					scales: {
						yAxes: [{
							ticks: {
								beginAtZero: true,
								callback: function(value, index, values) {
									return '$' + value.toLocaleString();
								}
							}
						}]
					}				
				}
		});
		}
	});
}

function yearlychart() {

	$.ajax({
		url:'chart-actions.php?view=yearlychart',
		type:"POST",
		contentType:"application/json; charset=utf-8",
		dataType:"json",
		success: function(data){                    
			console.log(data);

			var year = [];
			var total = [];

			for (var i in data) {
				console.log(data[i]);
				year.push(data[i].year);
				total.push(data[i].total);
			}

			var chartdata = {
				labels: year,
				datasets: [
				{
					label: 'Sales',
					backgroundColor: 'rgba(73,226,255,.7)',
					borderColor: '#38c4df',
					hoverBackgroundColor: 'rgba(0,0,0,.7)',
					hoverBorderColor: '#666666',
					data: total
				}
			],
		};

		var graphTarget = $("#yearlychart");
		var barGraph = new Chart(graphTarget, {
			type: 'bar',
			data: chartdata,
			options: {
				legend: {
					display: false
				},

				responsive: true,
				tooltips: {
						  callbacks: {
								label: function(tooltipItem, data) {
									var value = data.datasets[0].data[tooltipItem.index];
									 return priceFormat(value).replace(/\B(?=(\d{3})+(?!\d))/g, ",");
								}
						  } // end callbacks:
						},
					maintainAspectRatio: false,
					scales: {
						yAxes: [{
							ticks: {
								beginAtZero: true,
								fontColor: '#FFFFFF',

								callback: function(value, index, values) {
									return '$' + value.toLocaleString();
								}
							}
						}],
						xAxes: [{
							ticks: {
								fontColor: '#FFFFFF'

							}
						}]
					}
				}
			});
		}
	});
}



function showThirtyDayGraph() {
	$.ajax({
		url:'chart-actions.php?view=statsthirty',
		type:"POST",
		contentType:"application/json; charset=utf-8",
		dataType:"json",
		success: function(data){                    
			console.log(data);
			var vis = [];
			var pv = [];
			var date = [];

			for (var i in data) {
				console.log(data[i]);
				vis.push(data[i].vis);
				pv.push(data[i].pv);
				date.push(data[i].date);
				// $("#log").show().append(data[i].pv+" | ");
			}

			var chartdata = {
				labels: date,
				datasets: [
				{
					label: 'Visitors',
					backgroundColor: '#49e2ff',
					borderColor: '#46d5f1',
					hoverBackgroundColor: '#000000',
					hoverBorderColor: '#666666',
					data: vis
				},
				{
					label: 'Page Views',
					backgroundColor: '#f9a54b',
					borderColor: '#d48e43',
					hoverBackgroundColor: '#CCCCCC',
					hoverBorderColor: '#666666',
					data: pv
				}
			],
		};

		var graphTarget = $("#graphCanvas");
		var barGraph = new Chart(graphTarget, {
			type: 'bar',
			data: chartdata,
			options: {
				 responsive: true,
					maintainAspectRatio: false
				}
		});
		}
	});
}



function showDayGraph() {
	$.ajax({
		url:'chart-actions.php?view=statsdow',
		type:"POST",
		contentType:"application/json; charset=utf-8",
		dataType:"json",
		success: function(data){                    
			console.log(data);
			var vis = [];
			var pv = [];
			var dow = [];

			for (var i in data) {
				console.log(data[i]);
				vis.push(data[i].vis);
				pv.push(data[i].pv);
				dow.push(data[i].dow);
				// $("#log").show().append(data[i].pv+" | ");
			}

			var chartdata = {
				labels: dow,
				datasets: [
				{
					label: 'Visitors',
					backgroundColor: '#49e2ff',
					borderColor: '#46d5f1',
					hoverBackgroundColor: '#000000',
					hoverBorderColor: '#666666',
					data: vis
				},
				{
					label: 'Page Views',
					backgroundColor: '#f9a54b',
					borderColor: '#d48e43',
					hoverBackgroundColor: '#CCCCCC',
					hoverBorderColor: '#666666',
					data: pv
				}
			],
		};

		var graphTarget = $("#dowchart");
		var barGraph = new Chart(graphTarget, {
			type: 'bar',
			data: chartdata,
			options: {
				 responsive: true,
					maintainAspectRatio: false
				}
		});
		}
	});
}

function homeThirtyVisitors() {
	$.ajax({
		url:'chart-actions.php?view=statsthirty',
		type:"POST",
		contentType:"application/json; charset=utf-8",
		dataType:"json",
		success: function(data){                    
			console.log(data);
			var vis = [];
			var pv = [];
			var date = [];

			for (var i in data) {
				console.log(data[i]);
				vis.push(data[i].vis);
				pv.push(data[i].pv);
				date.push(data[i].date);
				// $("#log").show().append(data[i].pv+" | ");
			}

			var chartdata = {
				labels: date,
				datasets: [
				{
					label: 'Visitors',
					backgroundColor: 'rgba(73,226,255,.7)',
					borderColor: '#38c4df',
					hoverBackgroundColor: 'rgba(0,0,0,.7)',
					hoverBorderColor: '#666666',
					data: vis
				}
			],
		};

		var graphTarget = $("#homeThirtyVisitors");
		var barGraph = new Chart(graphTarget, {
			type: 'bar',
			data: chartdata,
			options: {
				legend: {
					display: false
				},
				 responsive: true,
				maintainAspectRatio: false,
				scales: {
					yAxes: [{
						ticks: {
							beginAtZero: true,
						}
					}],
					xAxes: [{
						ticks: {
							display: false

						}
					}]
				}
			}
		});
		}
	});
}



function homeThirtysales() {
	$.ajax({
		url:'chart-actions.php?view=thirtydaysales',
		type:"POST",
		contentType:"application/json; charset=utf-8",
		dataType:"json",
		success: function(data){                    
			console.log(data);
			var date = [];
			var sales = [];
			var expenses = [];
			var dateshow = [];

			for (var i in data) {
				console.log(data[i]);
				expenses.push(data[i].expenses);
				sales.push(data[i].sales);
				date.push(data[i].date);
				dateshow.push(data[i].dateshow);
				// $("#log").show().append(data[i].pv+" | ");
			}

			var chartdata = {
				labels: dateshow,
				datasets: [
				{
					label: 'Sales',
					backgroundColor: 'rgba(45,181,151,.7)',
					borderColor: 'rgba(73,255,86,.7)',
					hoverBackgroundColor: 'rgba(0,0,0,.7)',
					hoverBorderColor: '#000000',
					data: sales
				}
			],
		};

		var graphTarget = $("#homeThirtySales");
		var barGraph = new Chart(graphTarget, {
			type: 'bar',
			data: chartdata,
			options: {
				legend: {
					display: false
				},
				responsive: true,
				maintainAspectRatio: false,
				tooltips: {
						  callbacks: {
								label: function(tooltipItem, data) {
									var value = data.datasets[0].data[tooltipItem.index];
									 return priceFormat(value).replace(/\B(?=(\d{3})+(?!\d))/g, ",");
								}
						  } // end callbacks:
						},

				scales: {
					yAxes: [{
						ticks: {
							beginAtZero: true,
						}
					}],
					xAxes: [{
						ticks: {
							display: false

						}
					}]
				}
			}
		});
		}
	});
}